/* THIS PROGRAM IS PROVIDED "AS IS". TI MAKES NO WARRANTIES OR REPRESENTATIONS,
 * EITHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING ANY IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, LACK OF VIRUSES, ACCURACY
 * OR COMPLETENESS OF RESPONSES, RESULTS AND LACK OF NEGLIGENCE. TI DISCLAIMS
 * ANY WARRANTY OF TITLE, QUIET ENJOYMENT, QUIET POSSESSION, AND NON-INFRINGEMENT
 * OF ANY THIRD PARTY INTELLECTUAL PROPERTY RIGHTS WITH REGARD TO THE PROGRAM OR
 * YOUR USE OF THE PROGRAM.
 * IN NO EVENT SHALL TI BE LIABLE FOR ANY SPECIAL, INCIDENTAL, CONSEQUENTIAL OR
 * INDIRECT DAMAGES, HOWEVER CAUSED, ON ANY THEORY OF LIABILITY AND WHETHER OR
 * NOT TI HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES, ARISING IN ANY WAY
 * OUT OF THIS AGREEMENT, THE PROGRAM, OR YOUR USE OF THE PROGRAM.  EXCLUDED
 * DAMAGES INCLUDE, BUT ARE NOT LIMITED TO, COST OF REMOVAL OR REINSTALLATION,
 * COMPUTER TIME, LABOR COSTS, LOSS OF GOODWILL, LOSS OF PROFITS, LOSS OF
 * SAVINGS, OR LOSS OF USE OR INTERRUPTION OF BUSINESS. IN NO EVENT WILL TI'S
 * AGGREGATE LIABILITY UNDER THIS AGREEMENT OR ARISING OUT OF YOUR USE OF THE
 * PROGRAM EXCEED FIVE HUNDRED DOLLARS (U.S.$500).
 * Unless otherwise stated, the Program written and copyrighted by Texas
 * Instruments is distributed as "freeware".  You may, only under TI's copyright
 * in the Program, use and modify the Program without any charge or restriction.
 * You may distribute to third parties, provided that you transfer a copy of this
 * license to the third party and the third party agrees to these terms by its
 * first use of the Program. You must reproduce the copyright notice and any
 * other legend of ownership on each copy or partial copy, of the Program.
 * You acknowledge and agree that the Program contains copyrighted material,
 * trade secrets and other TI proprietary information and is protected by
 * copyright laws, international copyright treaties, and trade secret laws, as
 * well as other intellectual property laws.  To protect TI's rights in the
 * Program, you agree not to decompile, reverse engineer, disassemble or
 * otherwise translate any object code versions of the Program to a
 * human-readable form.  You agree that in no event will you alter, remove or
 * destroy any copyright notice included in the Program.  TI reserves all rights
 * not specifically granted under this license. Except as specifically provided
 * herein, nothing in this agreement shall be construed as conferring by
 * implication, estoppel, or otherwise, upon you, any license or other right
 * under any TI patents, copyrights or trade secrets.
 * You may not use the Program in non-TI devices. */


//******************************************************************************
//
//  main.h
//  Main function
//
//  Design Services - EMEA Power Management
//  Texas Instruments, Inc.
//
//******************************************************************************


#ifndef MAIN_H_
#define MAIN_H_


#include <msp430F2252.h>
#include <string.h>
#include "init.h"
#include "lcd.h"
#include "switch.h"
#include "adc.h"
#include "timerB.h"
#include "timerA.h"
#include "menu.h"
#include "flash.h"
#include "uart.h"



#define XTAL 16000000	// clock frequency in Hz to calculate delays
#define delay_us(us)	__delay_cycles( (XTAL/1000000) *us)
#define delay_ms(ms)	__delay_cycles( (XTAL/1000) *ms)



//******************************************************************************
// some useful macros
//******************************************************************************

// clear bit
#ifndef clear_bit
#define clear_bit(port, bit)	( port &= ~(bit) )
#endif

// set bit
#ifndef set_bit
#define set_bit(port, bit)		( port |= (bit))
#endif

// toggle bit
#ifndef toggle_bit
#define toggle_bit(port, bit)	( port ^= (bit))
#endif



//******************************************************************************
// definitions for the LCD backlight
//******************************************************************************

// bit for LCD backlight
#define BLIGHT_BIT		BIT0

// function select register for LCD backlight
#define BLIGHT_PSEL		P1SEL

// direction register for LCD backlight
#define BLIGHT_PDIR		P1DIR

// output register for LCD backlight
#define BLIGHT_POUT		P1OUT

// input register for LCD backlight
#define BLIGHT_PIN		P1IN

// pullup/-down resistor register for LCD backlight
#define BLIGHT_RES		P1REN



//******************************************************************************
// switch LCD backlight on/off
//******************************************************************************

// switch LCD backlight on
#define BLIGHT_on		set_bit(BLIGHT_POUT, BLIGHT_BIT)

// switch LCD backlight off
#define BLIGHT_off		clear_bit(BLIGHT_POUT, BLIGHT_BIT)



//******************************************************************************
// definitions for the LED
//******************************************************************************

// bit for LEDS
#define LED_GREEN_BIT			BIT0
#define LED_YELLOW_BIT			BIT1
#define LED_RED_BIT				BIT2

// function select register for LEDs
#define LED_PSEL		P3SEL

// direction register for LEDs
#define LED_PDIR		P3DIR

// output register for LEDs
#define LED_POUT		P3OUT

// input register for LEDs
#define LED_PIN			P3IN

// pullup/-down resistor register for LEDs
#define LED_RES			P3REN



//******************************************************************************
// switch LED on/off
//******************************************************************************

#define LED_green_off			clear_bit(LED_POUT, LED_GREEN_BIT)
#define LED_green_on			set_bit(LED_POUT, LED_GREEN_BIT)

#define LED_yellow_off			clear_bit(LED_POUT, LED_YELLOW_BIT)
#define LED_yellow_on			set_bit(LED_POUT, LED_YELLOW_BIT)

#define LED_red_off			clear_bit(LED_POUT, LED_RED_BIT)
#define LED_red_on			set_bit(LED_POUT, LED_RED_BIT)


//******************************************************************************
// definitions for the Full Bridge (FB) enable output
//******************************************************************************

// bit
#define ENABLE_FB_BIT		BIT7

// function select register
#define ENABLE_FB_PSEL		P4SEL

// direction register
#define ENABLE_FB_PDIR		P4DIR

// output register
#define ENABLE_FB_POUT		P4OUT

// input register
#define ENABLE_FB_PIN		P4IN

// pullup/-down resistor register
#define ENABLE_FB_RES		P4REN

//******************************************************************************
// definitions for the PFC Boost enable output
//******************************************************************************

// bit
#define ENABLE_PFC_BIT		BIT5

// function select register
#define ENABLE_PFC_PSEL		P2SEL

// direction register
#define ENABLE_PFC_PDIR		P2DIR

// output register
#define ENABLE_PFC_POUT		P2OUT

// input register
#define ENABLE_PFC_PIN		P2IN

// pullup/-down resistor register
#define ENABLE_PFC_RES		P2REN

//******************************************************************************
// definitions for the PFC precharge relay output
//******************************************************************************

// bit
#define PRECHARGE_RELAY_BIT			BIT6

// function select register
#define PRECHARGE_RELAY_PSEL		P2SEL

// direction register
#define PRECHARGE_RELAY_PDIR		P2DIR

// output register
#define PRECHARGE_RELAY_POUT		P2OUT

// input register
#define PRECHARGE_RELAY_PIN			P2IN

// pullup/-down resistor register
#define PRECHARGE_RELAY_RES			P2REN


//******************************************************************************
// definitions for the Load Connect output function
//******************************************************************************

// bit
#define LOAD_CONNECT_BIT		BIT7

// function select register
#define LOAD_CONNECT_PSEL		P2SEL

// direction register
#define LOAD_CONNECT_PDIR		P2DIR

// output register
#define LOAD_CONNECT_POUT		P2OUT

// input register
#define LOAD_CONNECT_PIN		P2IN

// pullup/-down resistor register
#define LOAD_CONNECT_RES		P2REN

//******************************************************************************
// definitions for the Full Bridge precharge FETs
//******************************************************************************

// bit
#define PRECHARGE_FB_BIT		BIT2

// function select register
#define PRECHARGE_FB_PSEL		P2SEL

// direction register
#define PRECHARGE_FB_PDIR		P2DIR

// output register
#define PRECHARGE_FB_POUT		P2OUT

// input register
#define PRECHARGE_FB_PIN		P2IN

// pullup/-down resistor register
#define PRECHARGE_FB_RES		P2REN

//******************************************************************************
// definitions for the FB precharge fail input (FBPFI)
//******************************************************************************

// bit for FBPFI
#define FAIL_PRECHARGE_BIT		BIT3

// function select register for FBPFI
#define FAIL_PRECHARGE_PSEL		P3SEL

// direction register for FBPFI
#define FAIL_PRECHARGE_PDIR		P3DIR

// input register for FBPFI
#define FAIL_PRECHARGE			P3IN

// pullup/-down resistor register for FBPFI
#define FAIL_PRECHARGE_RES		P3REN

//******************************************************************************
// definitions for the PFC Power Good input (PFC_PGD)
//******************************************************************************

// bit for PFC_PGD
#define PFC_PGD_BIT		BIT1

// function select register for PFC_PGD
#define PFC_PGD_PSEL		P2SEL

// direction register for PFC_PGD
#define PFC_PGD_PDIR		P2DIR

// input register for PFC_PGD
#define PFC_PGD			P2IN

// pullup/-down resistor register for PFC_PGD
#define PFC_PGD_RES		P2REN

//******************************************************************************
// definitions for the fan PWM input
//******************************************************************************

// bit for the fan
#define fan_BIT		BIT0

// function select register for fan
#define fan_PSEL		P4SEL

// direction register for fan
#define fan_PDIR		P4DIR

// input register for fan
#define fan_PIN			P4IN

// pullup/-down resistor register for fan
#define fan_RES			P4REN

//#define fan_PSEL2	ADC10AE0


//******************************************************************************
// enable/disable the Full Bridge
//******************************************************************************

// enable the Full Bridge
#define Full_bridge_on		set_bit(ENABLE_FB_POUT, ENABLE_FB_BIT)

// disable the Full Bridge
#define Full_bridge_off		clear_bit(ENABLE_FB_POUT, ENABLE_FB_BIT)

//******************************************************************************
// enable/disable the PFC Stage
//******************************************************************************

// enable the the PFC Stage
#define PFC_on		set_bit(ENABLE_PFC_POUT, ENABLE_PFC_BIT)

// disable the the PFC Stage
#define PFC_off		clear_bit(ENABLE_PFC_POUT, ENABLE_PFC_BIT)

//******************************************************************************
// Switch ON/OFF the PFC precharge relay
//******************************************************************************

// Switch ON the relay
#define Precharge_relay_on		set_bit(PRECHARGE_RELAY_POUT, PRECHARGE_RELAY_BIT)

// Switch OFF the relay
#define Precharge_relay_off		clear_bit(PRECHARGE_RELAY_POUT, PRECHARGE_RELAY_BIT)

//******************************************************************************
// Connect / Disconnect the load
//******************************************************************************

// Connect the load
#define Connect_load		set_bit(LOAD_CONNECT_POUT, LOAD_CONNECT_BIT)

// Disconnect the load
#define Disconnect_load		clear_bit(LOAD_CONNECT_POUT, LOAD_CONNECT_BIT)

//******************************************************************************
// Enable / Disable the SR Rectifier
//******************************************************************************

// Enable the SR Rectifier
#define Enable_SR		set_bit(SR_ENABLE_POUT, SR_ENABLE_BIT)

// Disable the SR Rectifier
#define Disable_SR		clear_bit(SR_ENABLE_POUT, SR_ENABLE_BIT)


//******************************************************************************
// Enable / Disable the Full Bridge precharge FETs
//******************************************************************************

// Enable the FETs
#define Precharge_fb_on		set_bit(PRECHARGE_FB_POUT, PRECHARGE_FB_BIT)

// Disable the FETs
#define Precharge_fb_off	clear_bit(PRECHARGE_FB_POUT, PRECHARGE_FB_BIT)

#define test	1

#endif /*MAIN_H*/
